varying vec2 texcoord;
varying vec3 np3;
#ifdef IS_IRIS
/* DRAWBUFFERS:8 */
#else
/* DRAWBUFFERS:2 */
#endif
void main()
{
    // Calculate skysize based on CLOUD_QUALITY
    const float skysize = 0.5 + float(CLOUD_QUALITY > 1) * 0.25 + float(CLOUD_QUALITY > 2) * 0.25;

    vec2 uv = gl_FragCoord.xy * texelSize / skysize;

    // Get cloud alpha
    float cloudAlpha = texture(colortex8, uv).a;

    // Calculate view factor from normalized eye height
    float invMag = inversesqrt(dot(np3, np3));           // ~1–2 cycles
    float normalizedY = np3.y * invMag;                  // ~1 cycle
    float viewFactor = normalizedY * normalizedY * 32.0; // ~2 cycles
#ifdef SKYBOX_SUPPORT
                                                         // Get skybox albedo
    vec4 albedo = texture(texture, texcoord);
    albedo.rgb *= toLinear(albedo.rgb) * viewFactor;
#else
                                                         // Calculate adjusted texture coordinates
    vec2 texSize = textureSize(texture, 0);
    vec2 texcoord0 = mix(clamp(texcoord * 1.5 - 0.25, 0.0, 1.0), texcoord, step(0.5, abs(texSize.x - texSize.y)));
    // Get albedo with adjusted coordinates
    vec4 albedo = texture(texture, texcoord0);
    albedo.rgb *= toLinear(albedo.rgb) * mix(2.0, 0.05, clamp(dot(moonPosWorld, vec3(np3)), 0, 1)) * viewFactor;
#endif

    albedo.a *= cloudAlpha;


    gl_FragData[0] = albedo;
}